<?php
$id=$_GET["id"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Entry Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <style>
        body {
            background-color:#fff;
            font-family: 'Arial', sans-serif;
        }
        .container {
            max-width: 500px;
            margin: auto;
            padding: 20px;
        }
        .back-button {
            font-size: 18px;
            cursor: pointer;
        }
        .profile-icon {
            width: 50px;
            height: 50px;
            background-color: #888;
            color: white;
            font-size: 20px;
            border-radius: 30%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        .amount {
            font-size: 24px;
            font-weight: bold;
            color: #ff4d4d;
            background: rgba(255, 0, 0, 0.1);
            padding: 10px;
            border-radius: 5px;
            display: inline-block;
        }
        .payment-badge {
            background-color: #d7d7ff;
            color: #444;
            padding: 5px 10px;
            border-radius: 5px;
            font-weight: bold;
        }
        .icon-text {
            color: green;
            font-weight: bold;
        }
        .divider {
            border-bottom: 1px solid #ddd;
            margin: 10px 0;
        }
        .profile-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 20px;
    color: white; /* Ensures letter is visible */
}

/* Assign different colors based on the first letter */
.A { background-color: #f44336; } /* Red */
.B { background-color: #e91e63; } /* Pink */
.C { background-color: #9c27b0; } /* Purple */
.D { background-color: #673ab7; } /* Deep Purple */
.E { background-color: #3f51b5; } /* Indigo */
.F { background-color: #2196f3; } /* Blue */
.G { background-color: #03a9f4; } /* Light Blue */
.H { background-color: #00bcd4; } /* Cyan */
.I { background-color: #009688; } /* Teal */
.J { background-color: #4caf50; } /* Green */
.K { background-color: #8bc34a; } /* Light Green */
.L { background-color: #cddc39; } /* Lime */
.M { background-color: #ffeb3b; } /* Yellow */
.N { background-color: #ffc107; } /* Amber */
.O { background-color: #ff9800; } /* Orange */
.P { background-color: #ff5722; } /* Deep Orange */
.Q { background-color: #795548; } /* Brown */
.R { background-color: #607d8b; } /* Blue Grey */
.S { background-color: #9e9e9e; } /* Grey */
.T { background-color: #ff4081; } /* Pink */
.U { background-color: #7c4dff; } /* Violet */
.V { background-color: #ff6e40; } /* Orange Red */
.W { background-color: #00e676; } /* Bright Green */
.X { background-color: #76ff03; } /* Light Lime */
.Y { background-color: #ff1744; } /* Bright Red */
.Z { background-color: #d500f9; } /* Bright Purple */

    </style>
</head>
<body>

<div class="container">
    <!-- Back button -->
    <div class="d-flex align-items-center mb-3">
       <a href="trans-receive.php?id=<?php echo$id?>"> <i class="fas fa-arrow-left back-button me-2" style="font-size:20px;"></i></a>
        <h5 class="mb-0">Entry Details</h5>
    </div>

    <!-- Profile & Title -->
    <div class="text-center">
        <div class="profile-icon mx-auto" id="profileletter">H</div>
        <p class="mt-2">to <strong id="customername"></strong></p>
        <span class="amount" >₹<span id="paymentamount">0.00</span></span>
    </div>

    <!-- Payment Confirmation -->
    <div class="text-center mt-3">
        <i class="fas fa-check-circle text-success"></i> 
        <span class="icon-text">You Gave - <span id="formattedDate"></span></span>
    </div>

    <!-- Details -->
    <div class="mt-3 text-center">
        <h5><strong>Agri Angadi</strong></h5>
    </div>

    <div class="divider"></div>

    <div class="d-flex justify-content-between">
        <span>Customer Notified via (SMS)</span>
        <span>No</span>
    </div>

    <div class="divider"></div>

    <div class="d-flex justify-content-between">
        <span>Record entered by</span>
        <span><strong id="customername1"></strong></span>
    </div>

    <div class="divider"></div>

    <div class="d-flex justify-content-between">
        <span>Payment Mode</span>
        <span class="payment-badge"></span>
    </div>

    <div class="divider"></div>

    <div class="d-flex justify-content-between">
        <span>Transaction ID</span>
        <span id="transactionid"></span>
    </div>
</div>
<script src="vendors/scripts/core.js"></script>
	<script src="vendors/scripts/script.min.js"></script>
	<script src="vendors/scripts/process.js"></script>
	<script src="vendors/scripts/layout-settings.js"></script>
	<script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
	<script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
	<!-- buttons for Export datatable -->
	<script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.print.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
	<script src="src/plugins/datatables/js/pdfmake.min.js"></script>
	<script src="src/plugins/datatables/js/vfs_fonts.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
    $(document).ready(function () {
    // Function to get query parameter from URL
    function getQueryParam(name) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(name);
    }

 
    // Fetch orderid from URL
    var Id = getQueryParam('paymentid');
   // Function to format date as "27 Feb 2025"
   function formatDate(inputDate) {
        const months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        let dateObj = new Date(inputDate);
        let day = dateObj.getDate();
        let month = months[dateObj.getMonth()];
        let year = dateObj.getFullYear();
        return `${day} ${month} ${year}`;
    }

     

    // Check if orderId is present
    if (Id) {
        $.ajax({
            url: 'https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/gettransdetails-api.php',
            method: 'GET',
            data: { paymentid: Id },
            success: function (response) {
                console.log('Full Response:', response);
                var data = typeof response === 'string' ? JSON.parse(response) : response;
                console.log('Parsed Data:', data);

                if (data && Object.keys(data).length > 0) {
                    console.log('Updating values...')
                
                    
                    let firstLetter = data.displayname.charAt(0).toUpperCase();
                    
                    // Define color map for letters
                    const colorMap = {
                        A: "#f44336", B: "#e91e63", C: "#9c27b0", D: "#673ab7", E: "#3f51b5",
                        F: "#2196f3", G: "#03a9f4", H: "#00bcd4", I: "#009688", J: "#4caf50",
                        K: "#8bc34a", L: "#cddc39", M: "#ffeb3b", N: "#ffc107", O: "#ff9800",
                        P: "#ff5722", Q: "#795548", R: "#607d8b", S: "#9e9e9e", T: "#ff4081",
                        U: "#7c4dff", V: "#ff6e40", W: "#00e676", X: "#76ff03", Y: "#ff1744", Z: "#d500f9"
                    };

                    let bgColor = colorMap[firstLetter] || "#000"; // Default to black if letter not found
                    
                    // Apply styles dynamically
                    $('#profileletter').css({
                        'background-color': bgColor,
                        'color': 'white',
                        'width': '50px',
                        'height': '50px',
                        'border-radius': '50%',
                        'display': 'flex',
                        'align-items': 'center',
                        'justify-content': 'center',
                        'font-weight': 'bold',
                        'font-size': '20px'
                    }).text(firstLetter);

                    $('#customername').text(data.displayname);
                    $('#customername1').text(data.displayname);
                    $('#paymentamount').text(data.Payment_amount ? parseFloat(data.Payment_amount).toFixed(2) : "0.00");
                    $('.payment-badge').text(data.Payment_type);
                    let formattedDate = formatDate(data.Payment_date); // Format the date
                    $('#formattedDate').text(formattedDate);
                    $('#transactionid').text(data.Reference_id ? data.Reference_id : "-");
                } else {
                    console.warn('No valid data received.');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error('AJAX error:', textStatus, errorThrown);
            }
        });
    }
});

</script>


</body>
</html>
